//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3
import QtQuick.Controls 1.1
import QtQuick.Controls.Styles 1.1
import QtGraphicalEffects 1.0

import wesual.Controls 1.0

Rectangle {
    id : pushButton

    property alias text     : label.text
    property bool isPrimary : true

    signal clicked()

    height : 30
    width  : label.implicitWidth >= 60 ? label.implicitWidth + 28 : 80
    color  : isPrimary ? UI.color(UI.SecondaryBase) : UI.color(UI.PrimaryBase)
    activeFocusOnTab : true

    // Key handling
    Keys.onEnterPressed  : clicked()
    Keys.onReturnPressed : clicked()

    QtObject {
        id : p_

        readonly property int animationDuration : 0
    }

    Rectangle {
        id : focusBorder

        anchors.fill : parent
        border {
            width : isPrimary ? 2 : 1
            color : isPrimary ? UI.color(UI.PrimaryFocusBorder) :
                                UI.color(UI.PrimaryFocusBorder, 0.4)
        }
        color : isPrimary ? "transparent" : UI.color(UI.PrimaryFocusBorder, 0.2)

        Rectangle {
            anchors {
                fill : parent
                margins : focusBorder.border.width
            }
            border {
                width : 1
                color : UI.color(UI.SecondaryFocusBorder)
            }
            color   : "transparent"
            visible : isPrimary  // show inner border only if primary button
        }
        visible : false
    }

    Text {
        id : label

        text  : text
        color : isPrimary ? UI.color(UI.PrimaryBase)
                          : UI.color(UI.LinkBaseColor)
        font.pixelSize : 14
        font.family : UI.fontFamily(UI.SecondaryFont)
        y : 20 - font.pixelSize
        anchors.horizontalCenter : parent.horizontalCenter
    }

    Rectangle {
        id : underline
        anchors {
            top : label.bottom
            topMargin : 1
            horizontalCenter : parent.horizontalCenter
        }
        width   : 0
        opacity : 0
        height  : 2
        color   : UI.color(UI.LinkLineColor)
        states : State {
            name : "display"
            when : !isPrimary &&
                   (mouseArea.containsMouse || pushButton.activeFocus)
            PropertyChanges {
                target : underline
                width : label.implicitWidth
                opacity : 1
            }
        }
        transitions : Transition {
           PropertyAnimation {
               properties : "width, opacity"
               duration : 0
               easing.type : Easing.InOutQuad
           }
        }
    } // underline

    states : [
        State {
            name : "disabled"
            when : !pushButton.enabled
            PropertyChanges {
                target : isPrimary ? pushButton : label
                color  : isPrimary ? UI.color(UI.DisabledButton)
                                   : UI.color(UI.DisabledText)
            }
        },
        State {
            name : "pressed"
            when : mouseArea.pressed
            PropertyChanges {
                target : isPrimary ? pushButton : label
                color  : isPrimary ? UI.color(UI.SecondaryPress) :
                                     UI.color(UI.LinkPressColor)
            }
        },
        State {
            name : "activeFocus_hovered"
            when : mouseArea.containsMouse && pushButton.activeFocus
            changes : [
                PropertyChanges {
                    target : isPrimary ? pushButton : label
                    color  : isPrimary ? UI.color(UI.SecondaryHover) :
                                         UI.color(UI.LinkBaseColor)
                },
                PropertyChanges {
                    target  : focusBorder
                    visible : true
                }
            ]
        },
        State {
            name : "activeFocus_only"
            when : pushButton.activeFocus
            PropertyChanges {
                target  : focusBorder
                visible : true
            }
        },
        State {
            name : "hovered"
            when : mouseArea.containsMouse
            PropertyChanges {
                target : isPrimary ? pushButton : label
                color  : isPrimary ? UI.color(UI.SecondaryHover) :
                                     UI.color(UI.LinkBaseColor)
            }
        }

    ]

    transitions: [
        Transition {
            ColorAnimation {
                duration : p_.animationDuration
            }
        }
    ]


    MouseArea {
        id : mouseArea

        enabled : pushButton.enabled
        anchors.fill : parent
        hoverEnabled : enabled
        onClicked    : pushButton.clicked();
        cursorShape  : Qt.PointingHandCursor
    }
}
